import { View, Text } from "react-native";
import React from "react";
import { itemDetailsStyles } from "../ItemDetailsStyle";
import usePreferences from "../../../../../../hooks/usePreferences";
import useLangTranslation from "../../../../../../hooks/useLangTranslation";

const ItemStock = ({
    type,
    stockManage,
    stock_hide,
    selectedVariation,
    isStock,
}) => {
    const { trans } = useLangTranslation();
    const {
        manage_stocks,
        stock_status,
        stock_quantity,
        criticalStockQuantity,
    } = stockManage || {};
    const { success } = selectedVariation || {};
    const {
        product_inventory: {
            manage_stock: preferenceManageStock,
            stock_display_format,
        } = {},
    } = usePreferences();
    return (
        <>
            {(preferenceManageStock == "0" ||
                (preferenceManageStock == "1" && manage_stocks == "0")) && (
                <View style={itemDetailsStyles.availabilityCont}>
                    <Text
                        style={itemDetailsStyles.stockText(isStock)}
                    >
                        {stock_status?.toLowerCase() == "out of stock"
                            ? trans("Out Of Stock")
                            : trans("In Stock")}
                    </Text>
                </View>
            )}
            {preferenceManageStock == "1" &&
                manage_stocks == "1" &&
                stock_hide != 1 &&
                (type == "Simple Product" ||
                    (type == "Variable Product" && success)) && (
                    <View style={itemDetailsStyles.availabilityCont}>
                        {stock_status &&
                            stock_display_format == "always_show" && (
                                <Text
                                    style={itemDetailsStyles.stockText(isStock)}
                                >
                                    {stock_status?.toLowerCase() ==
                                    "out of stock"
                                        ? trans("Out Of Stock")
                                        : trans("In Stock")}
                                </Text>
                            )}
                        {stock_quantity > 0 &&
                            stock_display_format == "always_show" && (
                                <Text style={itemDetailsStyles.stockQuantity}>
                                    {trans("{{x}} Items Remaining", {
                                        x: stock_quantity,
                                    })}
                                </Text>
                            )}
                        {stock_quantity > 0 &&
                            stock_quantity < criticalStockQuantity &&
                            stock_display_format == "sometime_show" && (
                                <Text style={itemDetailsStyles.stockQuantity}>
                                    {trans("Only {{x}} left in stock.", { x: stock_quantity,})}
                                </Text>
                            )}
                    </View>
                )}
        </>
    );
};

export default ItemStock;
